application.newDocument();

//load config file
var configFile = system.loadText("PMCConfig.xml");

//initializing global variables
var prevIndex = 0;
var Startindex;
var Endindex;

//getting user origin
var x_offset = get1Value("<x>","</x>");
var y_offset = get1Value("<y>","</y>");
var rz_offset = get1Value("<rotation>","</rotation>");

//getting starting position for IP Address of PMC
var stringToFind = "<PMCIPConfig>";
Startindex = configFile.indexOf(stringToFind,prevIndex) + stringToFind.length;
prevIndex = Startindex; 

//getting IP Address of PMC
var IPAddrArray = getArray("<value>","</value>",4);
var IPAddr = IPAddrArray[3] + "." + IPAddrArray[2] + "." + IPAddrArray[1] + "." + IPAddrArray[0];

//finding number of movers
var numMovers = get1Value("<max_mover>","</max_mover>");

//getting mover type
var moverType = getArray("<value>","</value>",numMovers);

//getting x and y positions of movers
var xpos = getArray("<value>","</value>",numMovers);
var ypos = getArray("<value>","</value>",numMovers);

//getting optional grid size
var gridSize = 0.24;
stringToFind = "<gridSize>";
if (configFile.indexOf(stringToFind,prevIndex) != -1){
    gridSize = get1Value("<gridSize>","</gridSize>");
}

//finding dimensions of flyway grid
var mcol = get1Value("<mcol>","</mcol>");
var mrow = get1Value("<mrow>","</mrow>");

//finding number of flyways
var numFlyways = get1Value("<flwCount>","</flwCount>");

//getting x and y positions of flyways
var col = getArray("<value>","</value>",numFlyways);
var row = getArray("<value>","</value>",numFlyways);

//getting x and y positions of flyways if there's gap
var gapPresent = 0;
stringToFind = "<gcfg>";
if (configFile.indexOf(stringToFind,prevIndex) != -1){
    gapPresent = 1;
    var all_pos = getArray("<value>","</value>",numFlyways*4);
}

//select initial root for the config
var parentpath = "Physics://physics";

//create top level trafo
loadDocument("lib/Origin.iphz",parentpath);
parentpath = parentpath + "/Origin";

//loading the flyways
for (var i = 0; i < numFlyways; i++){
    if (gapPresent == 0){
        loadDocument("lib/Flyway.iphz",parentpath,new Trafo(new Vec3(col[i]*gridSize,row[i]*gridSize,0)));
    }
    else{
        loadDocument("lib/Flyway.iphz",parentpath,new Trafo(new Vec3(all_pos[i*4],all_pos[i*4 + 1],0)));
    }
}

//load the trafo of the movers
loadDocument("lib/Main.iphz",parentpath,Trafo(Math.cos(rz_offset*Math.PI/2),Math.sin(rz_offset*Math.PI/2),0.0,0.0,
                                            -Math.sin(rz_offset*Math.PI/2),Math.cos(rz_offset*Math.PI/2),0.0,0.0,
                                            0.0,0.0,1.0,0.0,
                                            x_offset,y_offset,0.0,1.0));
parentpath = parentpath + "/Main";

//script of top level component
var mainScript = 'MODEL_SCRIPT(1.5)\n'
+ '\n'
+ 'DEFINITIONS:\n'
+ '\n'
+ 'VAR IPAddress := LOCAL(STRING,"' + IPAddr + '");\n'
+ 'VAR ipaddr := CONNECT(".?ipaddr");\n'
+ '\n'
+ 'CONST numMovers := CONNECT(".?numMovers");\n'
+ 'VAR isMaster := CONNECT(".?isMaster");\n'
+ 'VAR PLCconnect := CONNECT(".?PLCconnect");\n'
+ '\n'
+ 'STATEMENTS: \n'
+ '\n'
+ 'ipaddr := IPAddress;\n'
+ 'isMaster := TRUE;\n'
+ 'PLCconnect := FALSE;\n'
+ '\n'
+ 'END;\n';

//setting main script
setScriptText(parentpath,mainScript);

//keeping track of xbot count for attaching the scripts
//                  M3-06   M3-08   M3-09   M3-10   M3-11   M3-12   M3-13   M3-15   M3-17   M3-18   M3-25
var moverCount = [  0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0];
var scriptPath;
var initialRZ;

//loading the movers
for (var i = 0; i < numMovers; i++){
    
    switch(moverType[i]){ //getting the correct path for attaching scripts
        case 0: //M3-06
            loadDocument("lib/M3_06_04_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[0] == 0){
                scriptPath = parentpath + "/M3-06-04-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-06-04-OEM, XBOT" + (moverCount[0] + 1);
            }
            moverCount[0] = moverCount[0] + 1;
            initialRZ = 0;
            break;

        case 2: //M3-08X
            loadDocument("lib/M3_08_05_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[1] == 0){
                scriptPath = parentpath + "/M3-08-05-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-08-05-OEM, XBOT" + (moverCount[1] + 1);
            }
            moverCount[1] = moverCount[1] + 1;
            initialRZ = 0;
            break;

        case 3: //M3-08Y
            loadDocument("lib/M3_08_05_XBOT_OEM.iphz",parentpath,new Trafo(0.0,1.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,xpos[i],ypos[i],0.0,1.0));
            if (moverCount[1] == 0){
                scriptPath = parentpath + "/M3-08-05-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-08-05-OEM, XBOT" + (moverCount[1] + 1);
            }
            moverCount[1] = moverCount[1] + 1;
            initialRZ = Math.PI/2;
            break;

        case 4: //M3-09X
            loadDocument("lib/M3_09_01_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[2] == 0){
                scriptPath = parentpath + "/M3-09-01-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-09-01-OEM, XBOT" + (moverCount[2] + 1);
            }
            moverCount[2] = moverCount[2] + 1;
            initialRZ = 0;
            break;

        case 5: //M3-09Y
            loadDocument("lib/M3_09_01_XBOT_OEM.iphz",parentpath,new Trafo(0.0,1.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,xpos[i],ypos[i],0.0,1.0));
            if (moverCount[2] == 0){
                scriptPath = parentpath + "/M3-09-01-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-09-01-OEM, XBOT" + (moverCount[2] + 1);
            }
            moverCount[2] = moverCount[2] + 1;
            initialRZ = Math.PI/2;
            break;

        case 6: //M3-10
            loadDocument("lib/M3_10_03_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[3] == 0){
                scriptPath = parentpath + "/M3-10-03-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-10-03-OEM, XBOT" + (moverCount[3] + 1);
            }
            moverCount[3] = moverCount[3] + 1;
            initialRZ = 0;
            break;

        case 8: //M3-11X
            loadDocument("lib/M3_11_03_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[4] == 0){
                scriptPath = parentpath + "/M3-11-03-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-11-03-OEM, XBOT" + (moverCount[4] + 1);
            }
            moverCount[4] = moverCount[4] + 1;
            initialRZ = 0;
            break;

        case 9: //M3-11Y
            loadDocument("lib/M3_11_03_XBOT_OEM.iphz",parentpath,new Trafo(0.0,1.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,xpos[i],ypos[i],0.0,1.0));
            if (moverCount[4] == 0){
                scriptPath = parentpath + "/M3-11-03-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-11-03-OEM, XBOT" + (moverCount[4] + 1);
            }
            moverCount[4] = moverCount[4] + 1;
            initialRZ = Math.PI/2;
            break;

        case 12: //M3-12
            loadDocument("lib/M3_12_03_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[5] == 0){
                scriptPath = parentpath + "/M3-12-03-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-12-03-OEM, XBOT" + (moverCount[5] + 1);
            }
            moverCount[5] = moverCount[5] + 1;
            initialRZ = 0;
            break;

        case 14: //M3-13
            loadDocument("lib/M3_13_03_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[6] == 0){
                scriptPath = parentpath + "/M3-13-03-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-13-03-OEM, XBOT" + (moverCount[6] + 1);
            }
            moverCount[6] = moverCount[6] + 1;
            initialRZ = 0;
            break;

        case 16: //M3-15X
            loadDocument("lib/M3_15_05_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[7] == 0){
                scriptPath = parentpath + "/M3-15-05-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-15-05-OEM, XBOT" + (moverCount[7] + 1);
            }
            moverCount[7] = moverCount[7] + 1;
            initialRZ = 0;
            break;

        case 17: //M3-15Y
            loadDocument("lib/M3_15_05_XBOT_OEM.iphz",parentpath,new Trafo(0.0,1.0,0.0,0.0,-1.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,xpos[i],ypos[i],0.0,1.0));
            if (moverCount[7] == 0){
                scriptPath = parentpath + "/M3-15-05-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-15-05-OEM, XBOT" + (moverCount[7] + 1);
            }
            moverCount[7] = moverCount[7] + 1;
            initialRZ = Math.PI/2;
            break;
        
        case 18: //M3-17
            loadDocument("lib/M3_17_05_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[8] == 0){
                scriptPath = parentpath + "/M3-17-05-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-17-05-OEM, XBOT" + (moverCount[8] + 1);
            }
            moverCount[8] = moverCount[8] + 1;
            initialRZ = 0;
            break;

        case 20: //M3-18
            loadDocument("lib/M3_18_04_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[9] == 0){
                scriptPath = parentpath + "/M3-18-04-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-18-04-OEM, XBOT" + (moverCount[9] + 1);
            }
            moverCount[9] = moverCount[9] + 1;
            initialRZ = 0;
            break;

        case 22: //M3-25
            loadDocument("lib/M3_25_05_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[10] == 0){
                scriptPath = parentpath + "/M3-25-05-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-25-05-OEM, XBOT" + (moverCount[10] + 1);
            }
            moverCount[10] = moverCount[10] + 1;
            initialRZ = 0;
            break;
    
        default:
            loadDocument("lib/M3_06_04_XBOT_OEM.iphz",parentpath,new Trafo(new Vec3(xpos[i],ypos[i],0)));
            if (moverCount[0] == 0){
                scriptPath = parentpath + "/M3-06-04-OEM, XBOT";
            }
            else{
                scriptPath = parentpath + "/M3-06-04-OEM, XBOT" + (moverCount[0] + 1);
            }
            moverCount[0] = moverCount[0] + 1;
            initialRZ = 0;
            break;
        
    }

    var moverScript = 'MODEL_SCRIPT(1.5)\n'
    + 'DEFINITIONS:\n'
    + '\n'
    + '//Gives current position of mover\n'
    + 'CONST z_position := CONNECT(".?z_pos");\n'
    + 'CONST y_position := CONNECT(".?y_pos");\n'
    + 'CONST x_position := CONNECT(".?x_pos");\n'
    + 'CONST rx_position := CONNECT(".?rx_pos");\n'
    + 'CONST ry_position := CONNECT(".?ry_pos");\n'
    + 'CONST rz_position := CONNECT(".?rz_pos");\n'
    + '\n'
    + '//Gives current status of mover\n'
    + 'CONST status := CONNECT(".?status");\n'
    + '\n' 
    + '//Initial position of mover from xml\n' 
    + 'VAR initialX := CONNECT(".?initialX");\n'
    + 'VAR initialY := CONNECT(".?initialY");\n'
    + 'VAR initialRZ := CONNECT(".?initialRZ");\n'
    + 'VAR setInitialPos := LOCAL(INT32,1);\n'
    + '\n'
    + '//To toggle visibility when movers are removed from flyway\n' 
    + 'CONST isVisible := CONNECT(".?visible");\n'
    + 'VAR prevVisible := LOCAL(INT32,2);\n'
    + '\n'
    + '//To move part in iPhysics\n' 
    + 'VAR trafoDrive := CONNECT(".?TrafoDrive");\n'
    + 'VAR trafo := LOCAL(POSE6,POSE6(0.0,0.0,0.0,0.0,0.0,0.0));  \n'
    + '\n'
    + 'VAR isMaster := CONNECT(".?isMaster");\n'
    + 'VAR moverID := CONNECT(".?MoverID");\n'
    + '\n'
    + 'STATEMENTS: \n'
    + '\n'
    + 'moverID := ' + (i+1) + ';\n'
    + 'isMaster := FALSE;\n'
    + '\n'
    + '//if hidden, no need to do anything\n'
    + 'IF isVisible = 1 THEN\n'
    + '\n'
    + 'initialX := ' + xpos[i] + ';\n'
    + 'initialY := ' + ypos[i] + ';\n'
    + 'initialRZ := ' + initialRZ + ';\n'
    + '\n'
    + '//assign current position to model in iPhysics\n'
    + 'trafo.x := x_position;\n'
    + 'trafo.y := y_position;\n'
    + 'trafo.z := z_position;\n'
    + '\n'
    + 'trafo.c := rx_position;\n'
    + 'trafo.b := ry_position;\n'
    + 'trafo.a := rz_position;\n'
    + '\n'
    + '//set initial position to the one given in xml (else would go to (0,0))\n'
    + 'IF (x_position = 0 AND y_position = 0) THEN\n'
    + '    IF setInitialPos = 1 THEN\n'
    + '        trafo.x := initialX;\n'
    + '        trafo.y := initialY;\n'
    + '        trafo.a := initialRZ;\n'
    + '    END_IF\n'
    + 'ELSE\n'
    + '    setInitialPos := 0;\n'
    + 'END_IF\n'
    + '\n'
    + 'trafoDrive := trafo;\n'
    + '\n'
    + 'END_IF\n'
    + '\n'
    + '//check if previous iteration has same visibility\n'
    + '//better to avoid calling evaljs if not needed (based on documentation)\n'
    + 'IF prevVisible <> isVisible THEN\n'
    + '    IF isVisible = 1 THEN\n'
    + '        eval_js("setVisible(\'' + scriptPath + '\',true)");\n'
    + '    ELSE\n'
    + '        eval_js("setVisible(\'' + scriptPath + '\',false)");\n'
    + '    END_IF\n'
    + '    prevVisible := isVisible;\n'
    + 'END_IF\n'
    + '\n'
    + 'END;\n';

    setScriptText(scriptPath,moverScript);
}

document.save("Layout.iphz");
view3D.setBackground("0.0:#222;0.5:#ccebff;1.0:#222");

//function to get 1 value from the config file
function get1Value(startString,EndString){
    Startindex = configFile.indexOf(startString,prevIndex) + startString.length;
    Endindex = configFile.indexOf(EndString,Startindex);
    prevIndex = Endindex; 
    return Number(configFile.slice(Startindex,Endindex));
}

//function to get an array of values from the config file
function getArray(startString,EndString,Count){
    const values = [];
    for (var i = 0; i < Count; i++){
        Startindex = configFile.indexOf(startString,prevIndex) + startString.length;
        Endindex = configFile.indexOf(EndString,Startindex);
        prevIndex = Endindex; 
        values[i] = Number(configFile.slice(Startindex,Endindex));
    }
    return values;
}